﻿# -*- coding: utf-8 -*-

from .api import API, TokenNotFound, TokenRenewFailed
from .common import *


class Navigation():
	def _addContextMenuFav(self, favor_id, favor_title, listitem):
		if favor_id in self._favour:
			listitem.addContextMenuItems([(translation(30651), f"RunPlugin({build_mass({'action': 'removeFav', 'favor_id': favor_id, 'favor_title': favor_title})})")])
		else:
			listitem.addContextMenuItems([(translation(30652), f"RunPlugin({build_mass({'action': 'addFav', 'favor_id': favor_id, 'favor_title': favor_title})})")])

	def __init__(self, ):
		self._showVodsPay = False
		self._showLivePay = False
		self._showEventPay = False
		self._showPodcastPay = False
		self._prefMethod = (True if addon_tvnow.getSetting('sorting_technique') == "0" else False)
		self._hidePayed = (True if addon_tvnow.getSetting('hide_paycontent') == "true" else False)
		self._colorMovie = addon_tvnow.getSetting('title_marking')
		self._showSettings = addon_tvnow.getSetting('show_settings') == "true"
		self.user = addon_tvnow.getSetting('email')
		self.signature = addon_tvnow.getSetting('signature')
		token = addon_tvnow.getSetting('acc_token')
		refresh_token = addon_tvnow.getSetting('refresh_token')
		lastUpdate = addon_tvnow.getSetting('versionLastUpdate')
		lastUpdateInt = 0
		try: lastUpdateInt = float(lastUpdate)
		except: pass
		if lastUpdateInt > time.time() - 60*60*24:
			clientID = addon_tvnow.getSetting('clientID')
			version = addon_tvnow.getSetting('version')
		else:
			clientID = API.getClientID()
			version = API.getClientVersion()
			addon_tvnow.setSetting('clientID', clientID)
			addon_tvnow.setSetting('version', version)
			addon_tvnow.setSetting('versionLastUpdate', str(time.time()))
		try:
			self.api = API(token, refresh_token, clientID=clientID, clientVersion=version)
		except TokenNotFound:
			dialog.ok(addon_id, translation(30503))
			return
		except TokenRenewFailed:
			dialog.ok(addon_id, translation(30504))
			self.api = API(clientID=clientID, clientVersion=version)
			self.create_account()

		if token != self.api.getToken():
			addon_tvnow.setSetting('acc_token', self.api.getToken())
		if refresh_token != self.api.getRefreshToken():
			addon_tvnow.setSetting('refresh_token', self.api.getRefreshToken())
		try:
			base64Parts = token.split(".")
			userToken = "%s==" % base64Parts[1]
			userData = json.loads(base64.b64decode(userToken))
			if "permissions" in userData:
				if "streaming" in userData["permissions"]:
					if "vodAccessToPayContent" in userData["permissions"]["streaming"] and userData["permissions"]["streaming"]["vodAccessToPayContent"]==True:
						self._showVodsPay = True
					if "livestreamAccessToPayTv" in userData["permissions"]["streaming"] and userData["permissions"]["streaming"]["livestreamAccessToPayTv"]==True:
						self._showLivePay = True
					if "liveeventAccessToPayTv" in userData["permissions"]["streaming"] and userData["permissions"]["streaming"]["liveeventAccessToPayTv"]==True:
						self._showEventPay = True
				if "podcasts" in userData["permissions"]:
					if "accessPremiumPodcasts" in userData["permissions"]["podcasts"] and userData["permissions"]["podcasts"]["accessPremiumPodcasts"]==True:
						self._showPodcastPay = True
		except: pass
		self._favour = []
		if self.user != "":
			if self.signature == "":
				addon_tvnow.setSetting('signature', self.user)
			favour = self.api.getFavorites(preserve(FAVORIT_FILE, 1))
			self._favour = favour

	def mainMenu(self):
		if self._showVodsPay:
			addDir({'action': 'listFavorites'}, create_entries({'Title': translation(30601), 'Image': f"{artpic}watchlist.png"}))
		addDir({'action': 'topicworldOverview', 'case_id': 'SPORTS'}, create_entries({'Title': translation(30602)}))
		addDir({'action': 'listOverviews', 'case_id': 'SHOW', 'species': SHOWS_FILE}, create_entries({'Title': translation(30603)}))
		addDir({'action': 'listOverviews', 'case_id': 'SERIES', 'species': SERIES_FILE}, create_entries({'Title': translation(30604)}))
		addDir({'action': 'listOverviews', 'case_id': 'MOVIE', 'species': MOVIES_FILE}, create_entries({'Title': translation(30605)}))
		if self._showLivePay:
			addDir({'action': 'listStations', 'case_id': 'BROADCAST'}, create_entries({'Title': translation(30606), 'Image': f"{artpic}livestream.png"}))
		addDir({'action': 'listStations', 'case_id': 'FAST'}, create_entries({'Title': translation(30607), 'Image': f"{artpic}faststream.png"}))
		addDir({'action': 'listEvents'}, create_entries({'Title': translation(30608), 'Image': f"{artpic}eventstream.png"}))
		addDir({'action': 'recommendOverview'}, create_entries({'Title': translation(30609)}))
		addDir({'action': 'topicworldOverview', 'case_id': 'OTHERS'}, create_entries({'Title': translation(30610)}))
		addDir({'action': 'search'}, create_entries({'Title': translation(30611), 'Image': f"{artpic}basesearch.png"}))
		if self._showSettings:
			addDir({'action': 'adjustment'}, create_entries({'Title': translation(30612), 'Image': f"{artpic}settings.png"}), folder=False)
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def listFavorites(self):
		if self._showVodsPay:
			xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
			favorites = []
			for item in sorted(self.api.getWatchlist(), key=lambda en: cleanUmlaut(en.get('title', 'zorro').lower())):
				if item.get('__typename') in ['Movie', 'Format'] and item.get('id'): # Nur Movie+Format anzeigen (MOVIE, SHOW, SERIES)
					favorites.append(item.get('id'))
					action = 'listMovies' if item.get('__typename') == 'Movie' else 'listSeasons'
					signes = None if item.get('__typename') == 'Movie' else 'SHOW'
					each = self.create_substances(item, signes, COLOUR=True) # SIGNES=signes / DETAILS=False / SAISON=None / COLOUR=True
					# [ident=0, species=1, premium=2, name=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, note_3=11]
					# [startdate=12, begins=13, aired=14, year=15, genre=16, country=17, CASTING=18, mpaa=19, thumb=20, poster=21]
					PLOT = f"{each[9]}{each[10]}{each[11]}{each[5]}"
					FETCH_UNO = create_entries({'Title': each[3], 'TvShowTitle': each[4], 'Plot': PLOT, 'Genre': each[16], 'Image': each[20], 'Poster': each[21]})
					self._addContextMenuFav(each[0], each[3], FETCH_UNO)
					addDir({'action': action, 'id': each[0], 'series_title': each[4]}, FETCH_UNO)
			preserve(FAVORIT_FILE, 1, favorites)
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def addFav(self, favor_id, favor_title):
		if self.api.modifyWatchlist(favor_id, 'addFavorite'):
			dialog.notification(translation(30541), translation(30542).format(favor_title), icon, 10000)
		else:
			dialog.notification(translation(30541), translation(30543).format(favor_title), icon, 10000)
		favour = self.api.getFavorites()

	def removeFav(self, favor_id, favor_title):
		if self.api.modifyWatchlist(favor_id, 'deleteFavorite'):
			xbmc.executebuiltin('Container.Refresh')
			xbmc.sleep(1000)
			dialog.notification(translation(30541), translation(30544).format(favor_title), icon, 10000)
		else:
			dialog.notification(translation(30541), translation(30545).format(favor_title), icon, 10000)
		favour = self.api.getFavorites()

	def listOverviews(self, case_id, species):
		xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
		default, hiding = (0 for _ in range(2))
		entries = [view for view in self.api.getOverviews(case_id, species, cache_data=preserve(species, 12))]
		for item in sorted(entries, key=lambda en: cleanUmlaut(en.get('title', 'zorro').lower())):
			action = 'listMovies' if case_id == 'MOVIE' else 'listSeasons'
			signes = None if case_id == 'MOVIE' else 'SHOW'
			each = self.create_substances(item, signes) # SIGNES=signes / DETAILS=False / SAISON=None / COLOUR=False
			# [ident=0, species=1, premium=2, name=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, note_3=11]
			# [startdate=12, begins=13, aired=14, year=15, genre=16, country=17, CASTING=18, mpaa=19, thumb=20, poster=21]
			default += 1
			if self._showVodsPay is False and each[2] is True and self._hidePayed is True:
				hiding = hiding.__add__(1)
				continue
			PLOT = f"{each[9]}{each[10]}{each[11]}{each[5]}"
			FETCH_UNO = create_entries({'Title': each[3], 'TvShowTitle': each[4], 'Plot': PLOT, 'Genre': each[16], 'Image': each[20], 'Poster': each[21]})
			if self._showVodsPay:
				self._addContextMenuFav(each[0], each[3], FETCH_UNO)
			addDir({'action': action, 'id': each[0], 'series_title': each[4]}, FETCH_UNO)
		if default == 0:
			return dialog.notification(translation(30551), translation(30553).format(case_id), icon, 10000)
		elif default == hiding:
			return dialog.notification(translation(30552), translation(30553).format(case_id), icon, 10000)
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def listSeasons(self, series_id, series_title):
		xbmcplugin.setContent(ADDON_HANDLE, 'seasons')
		entries = self.api.getSeasons(series_id)
		for item in sorted(entries.get('seasons', []), key=lambda sn: (int(sn.get('ordinal', 0)) if sn.get('seasonType','') == 'ORDINAL' else (int(sn.get('year', 0)), int(sn.get('month', 0)))), reverse=self._prefMethod):
			each = self.create_substances(entries, series_title, True) # SIGNES=series_title / DETAILS=True / SAISON=None / COLOUR=False
			# [ident=0, species=1, premium=2, name=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, note_3=11]
			# [startdate=12, begins=13, aired=14, year=15, genre=16, country=17, CASTING=18, mpaa=19, thumb=20, poster=21]
			TITLE = f"Staffel {int(item.get('ordinal', 00))}" if item.get('seasonType','') == 'ORDINAL' else f"{int(item.get('month', 00)):02}.{int(item.get('year', 00)):04}"
			SEAS_NUM = f"{int(item.get('ordinal', 00)):02}" if item.get('seasonType','') == 'ORDINAL' else f"{int(item.get('year', 00)):04}"
			PLOT = f"{each[9]}{each[10]}{each[11]}{each[5]}"
			YEAR = f"{int(item['year']):04}" if str(item.get('year')).isdecimal() else None
			FETCH_UNO = create_entries({'Title': TITLE, 'TvShowTitle': each[4], 'Plot': PLOT, 'Year': YEAR, \
				'Genre': each[16], 'Country': each[17], 'Image': each[20], 'Poster': each[21]})
			addDir({'action': 'listEpisodes', 'season_id': item['id'], 'season_num': SEAS_NUM, 'series_title': each[4]}, FETCH_UNO)
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def listEpisodes(self, season_id, season_num, series_title):
		xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
		default, hiding = (0 for _ in range(2))
		for item in sorted(self.api.getEpisodes(season_id), key=lambda es: int(es.get('number', 0)), reverse=self._prefMethod):
			action = 'playVod'
			each = self.create_substances(item, series_title, True, season_num) # SIGNES=series_title / DETAILS=True / SAISON=season_num / COLOUR=False
			# [ident=0, species=1, premium=2, name=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, note_3=11]
			# [startdate=12, begins=13, aired=14, year=15, genre=16, country=17, CASTING=18, mpaa=19, thumb=20, poster=21]
			default += 1
			if self._showVodsPay is False and each[2] is True:
				action = 'forbidden'
				if self._hidePayed is True:
					hiding = hiding.__add__(1)
					continue
			PLOT = f"{each[9]}{each[10]}{each[11]}{each[5]}"
			FETCH_UNO = create_entries({'Title': each[3], 'TvShowTitle': each[4], 'Plot': PLOT, 'Duration': each[6], 'Season': each[7], 'Episode': each[8], \
				'Date': each[13], 'Aired': each[14], 'Year': each[15], 'Genre': each[16], 'Country': each[17], 'Cast': each[18], 'Mpaa': each[19], \
				'Mediatype': 'episode', 'Image': each[20], 'Poster': each[21], 'Reference': 'Standard' if action == 'forbidden' else 'Single'})
			addDir({'action': action, 'id': each[0]}, FETCH_UNO, folder=False)
		if default == 0:
			return dialog.notification(translation(30551), translation(30553).format(series_title), icon, 10000)
		elif default == hiding:
			return dialog.notification(translation(30552), translation(30553).format(series_title), icon, 10000)
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def listMovies(self, movie_id):
		xbmcplugin.setContent(ADDON_HANDLE, 'movies')
		entries = [mov for mov in self.api.getMovies(movie_id)]
		for item in entries:
			action = 'playVod'
			each = self.create_substances(item['data']['movie'], None, True) # SIGNES=None / DETAILS=True / SAISON=None / COLOUR=False
			# [ident=0, species=1, premium=2, name=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, note_3=11]
			# [startdate=12, begins=13, aired=14, year=15, genre=16, country=17, CASTING=18, mpaa=19, thumb=20, poster=21]
			if self._showVodsPay is False and each[2] is True:
				action = 'forbidden'
				if self._hidePayed is True:
					continue
			PLOT = f"{each[9]}{each[10]}{each[11]}{each[5]}"
			FETCH_UNO = create_entries({'Title': each[3], 'Plot': PLOT, 'Duration': each[6], 'Date': each[13], 'Aired': each[14], \
				'Year': each[15], 'Genre': each[16], 'Country': each[17], 'Cast': each[18],'Mpaa': each[19], 'Mediatype': 'movie', \
				'Image': each[20], 'Poster': each[21], 'Reference': 'Standard' if action == 'forbidden' else 'Single'})
			addDir({'action': action, 'id': each[0]}, FETCH_UNO, folder=False)
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def listStations(self, case_id):
		if self._showLivePay or case_id == 'FAST':
			entries = [can for can in self.api.getStations(case_id)]
			for item in sorted(entries, key=lambda tvs: tvs[1].lower()):
				GENRE = ' / '.join(sorted([gen for gen in item[6]])) if item[6] else 'FastTV' if item[4] == 'FAST' else 'LiveTV'
				FETCH_UNO = create_entries({'Title': item[2], 'Plot': item[8], 'Genre': GENRE, \
					'Mediatype': 'episode', 'Image': item[7], 'Poster': item[7], 'Reference': 'Single'})
				addDir({'action': 'playVod', 'id': item[0]}, FETCH_UNO, folder=False)
		xbmcplugin.endOfDirectory(ADDON_HANDLE, cacheToDisc=False)

	def listEvents(self):
		xbmcplugin.setContent(ADDON_HANDLE, 'videos')
		RESULTS, (default, hiding) = [], (0 for _ in range(2))
		for entries in self.api.getEvents():
			for item in entries.get('events', []):
				each = self.create_substances(item, 'SHOW') # SIGNES=SHOW / DETAILS=False / SAISON=None / COLOUR=False
				# [ident=0, species=1, premium=2, name=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, note_3=11]
				# [startdate=12, begins=13, aired=14, year=15, genre=16, country=17, CASTING=18, mpaa=19, thumb=20, poster=21]
				timing = get_CentralTime(item.get('streamStart', '2025-01-01T00:00:00'))
				action = 'playVod' if datetime.now() > timing - timedelta(minutes=15) else 'blankFUNC'
				default += 1
				if self._showVodsPay is False and each[2] is True:
					action = 'forbidden'
					if self._hidePayed is True:
						hiding = hiding.__add__(1)
						continue
				RESULTS.append([action, timing, each])
		if RESULTS:
			for action, timing, each in sorted(RESULTS, key=lambda evs: evs[1]):
				TITLE = translation(30631).format(each[12], each[3])
				PLOT = f"{each[9]}{each[10]}{each[11]}{each[5]}"
				FETCH_UNO = create_entries({'Title': TITLE, 'Plot': PLOT, 'Date': each[13], 'Aired': each[14], 'Year': str(timing)[:4], 'Genre': each[16], \
					'Mpaa': each[19], 'Mediatype': 'movie', 'Image': each[20], 'Poster': each[21], 'Reference': 'Single' if action == 'playVod' else 'Standard'})
				addDir({'action': action, 'id': each[0]}, FETCH_UNO, folder=False)
		elif default == 0:
			return dialog.notification(translation(30551), translation(30553).format('Events'), icon, 10000)
		elif default == hiding:
			return dialog.notification(translation(30552), translation(30553).format('Events'), icon, 10000)
		xbmcplugin.endOfDirectory(ADDON_HANDLE, cacheToDisc=False)

	def recommendOverview(self):
		xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
		entries = [view for view in self.api.getRecommendOverview(cache_data=preserve(RECOM_FILE, 12))]
		results = sorted(entries, key=lambda en: cleanUmlaut(en.get('title', 'zorro').lower())) if self._showVodsPay is False else entries
		for item in results:
			if item.get('__typename') in ['TeaserWidget', 'SavedFavoriteWidget', 'WidgetContinue'] and item.get('id') and item.get('title'):
				elements = item.get('elements', [])
				title = item['title']
				excluding = [ex for ex in elements if ex and ex.get('__typename') == 'ExternalTeaser']
				if 'themenwelten' in title.lower() or len(elements) < 1 or len(elements) == len(excluding): # Themenwelt-Links ausblenden
					continue
				addDir({'action': 'listRecommendTopic', 'trace_id': item['id'], 'species': 'recommend', 'trace_title': title}, create_entries({'Title': title}))
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def topicworldOverview(self, case_id):
		xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
		if case_id == 'SPORTS':
			for entries in self.api.getTopicworldsContent('sport', 'sports_folder'):
				if entries.get('id', '') == '5bd6b37b-1810-4fc3-b9df-cdd01c10f022' and entries.get('title'):
					for item in entries['content'].get('items', []):
						if not item.get('path'): continue
						addDir({'action': 'listRecommendTopic', 'trace_id': item['path'], 'species': 'topicworld', 'trace_title': item['title']}, create_entries({'Title': item['title']}))
		else:
			entries = [view for view in self.api.getTopicworldOverview()]
			for item in sorted(entries, key=lambda en: cleanUmlaut(en.get('title', 'zorro').lower())):
				thumb = item['image']['thumbnail'] if item.get('image', '') and item['image'].get('thumbnail', '') else icon
				addDir({'action': 'listRecommendTopic', 'trace_id': item['path'], 'species': 'topicworld', 'trace_title': item['title']}, create_entries({'Title': item['title'], 'Image': thumb}, False))
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def listRecommendTopic(self, trace_id, species, trace_title):
		xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
		default, hiding = (0 for _ in range(2))
		if species == 'recommend':
			entries = [com for com in self.api.getRecommendsContent(trace_id, cache_data=preserve(RECOM_FILE, 12))]
		else:
			entries = [com for com in self.api.getTopicworldsContent(trace_id)]
		for item in sorted(entries, key=lambda en: cleanUmlaut(en.get('title', 'zorro').lower())):
			if item.get('__typename') in ['Movie', 'Format'] and item.get('id'): # Nur Movie+Format anzeigen (MOVIE, SHOW, SERIES)
				if item.get('__typename') == 'Format' and int(item.get('numberOfSeasons', 1)) == 0: # SHOW+SERIES ohne Staffel ausblenden - da keine Folgen vorhanden
					continue
				action = 'listMovies' if item.get('__typename') == 'Movie' else 'listSeasons'
				signes = None if item.get('__typename') == 'Movie' else 'SHOW'
				each = self.create_substances(item, signes, COLOUR=True) # SIGNES=signes / DETAILS=False / SAISON=None / COLOUR=True
				# [ident=0, species=1, premium=2, name=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, note_3=11]
				# [startdate=12, begins=13, aired=14, year=15, genre=16, country=17, CASTING=18, mpaa=19, thumb=20, poster=21]
				default += 1
				if self._showVodsPay is False and each[2] is True and self._hidePayed is True:
					hiding = hiding.__add__(1)
					continue
				PLOT = f"{each[9]}{each[10]}{each[11]}{each[5]}"
				FETCH_UNO = create_entries({'Title': each[3], 'TvShowTitle': each[4], 'Plot': PLOT, 'Genre': each[16], 'Image': each[20], 'Poster': each[21]})
				if self._showVodsPay:
					self._addContextMenuFav(each[0], each[3], FETCH_UNO)
				addDir({'action': action, 'id': each[0], 'series_title': each[4]}, FETCH_UNO)
		if default == 0:
			return dialog.notification(translation(30551), translation(30553).format(trace_title.title()), icon, 10000)
		elif default == hiding:
			return dialog.notification(translation(30552), translation(30553).format(trace_title.title()), icon, 10000)
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def searching(self):
		keyword = dialog.input(translation(30633), type=xbmcgui.INPUT_ALPHANUM, autoclose=15000)
		self.listSearchResults(keyword) if keyword else None

	def listSearchResults(self, queries):
		xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
		default, hiding = (0 for _ in range(2))
		entries = [ask for ask in self.api.getSearchResults(queries)]
		for item in sorted(entries, key=lambda en: cleanUmlaut(en.get('title', 'zorro').lower())):
			if item.get('__typename') in ['Movie', 'Format'] and item.get('id'): # Nur Movie+Format anzeigen (MOVIE, SHOW, SERIES)
				action = 'listMovies' if item.get('__typename') == 'Movie' else 'listSeasons'
				signes = None if item.get('__typename') == 'Movie' else 'SHOW'
				each = self.create_substances(item, signes, COLOUR=True) # SIGNES=signes / DETAILS=False / SAISON=None / COLOUR=True
				# [ident=0, species=1, premium=2, name=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, note_3=11]
				# [startdate=12, begins=13, aired=14, year=15, genre=16, country=17, CASTING=18, mpaa=19, thumb=20, poster=21]
				default += 1
				if self._showVodsPay is False and each[2] is True and self._hidePayed is True:
					hiding = hiding.__add__(1)
					continue
				PLOT = f"{each[9]}{each[10]}{each[11]}{each[5]}"
				FETCH_UNO = create_entries({'Title': each[3], 'TvShowTitle': each[4], 'Plot': PLOT, 'Genre': each[16], 'Image': each[20], 'Poster': each[21]})
				if self._showVodsPay:
					self._addContextMenuFav(each[0], each[3], FETCH_UNO)
				addDir({'action': action, 'id': each[0], 'series_title': each[4]}, FETCH_UNO)
		if default == 0:
			return dialog.notification(translation(30551), translation(30553).format(queries), icon, 10000)
		elif default == hiding:
			return dialog.notification(translation(30552), translation(30553).format(queries), icon, 10000)
		xbmcplugin.endOfDirectory(ADDON_HANDLE)

	def create_substances(self, rsx, SIGNES=None, DETAILS=False, SAISON=None, COLOUR=False):
		CASTING, (suffix, note_1, note_2, note_3, desc) = [], ("" for _ in range(5))
		seriestitle, startdate, notedate, aired, begins, mpaa, country, genre, thumb, poster = (None for _ in range(10))
		ident = rsx.get('id', '00')
		species = rsx.get('__typename', None)
		permission = (rsx.get('tier', '') or rsx.get('requiredPermission', '') or "")
		premium = (True if permission in ['PREMIUM', 'liveeventAccessToPayTv'] else False)
		title = (rsx.get('title') or rsx.get('name')).strip()
		seriestitle = title if SIGNES in ['SHOW', 'SERIES', 'UKNOWN'] else SIGNES
		if premium and self._showVodsPay is False:
			suffix = '   [COLOR deepskyblue](premium)[/COLOR]'
		if SIGNES in ['SHOW', 'SERIES', 'UKNOWN', None]:
			note_1 = translation(32101).format(title) if premium and self._showVodsPay is False else translation(32102).format(title)
		elif SIGNES not in ['SHOW', 'SERIES', 'UKNOWN', None]:
			note_1 = translation(32101).format(SIGNES) if premium and self._showVodsPay is False else translation(32102).format(SIGNES)
		desc = (rsx.get('descriptionV2', '') or rsx.get('emptyFormatText', '') or rsx.get('description', '') or "")
		duration = int(rsx['durationInSecondsV2']) if str(rsx.get('durationInSecondsV2')).isdecimal() else None
		season = f"{int(rsx['season']):02}" if str(rsx.get('season')).isdecimal() and int(rsx.get('season')) != 0 else None
		season = f"{int(SAISON):02}" if season is None and str(SAISON).isdecimal() and int(SAISON) != 0 else season
		episode = f"{int(rsx['number']):02}" if str(rsx.get('number')).isdecimal() and int(rsx.get('number')) != 0 else None
		if season and episode:
			name = translation(32103).format(season, episode, f"{title}{suffix}")
			note_2 = translation(32104).format(season, episode)
		elif season is None and episode:
			name = translation(32105).format(episode, f"{title}{suffix}")
			note_2 = translation(32106).format(episode)
		else: name = translation(32107).format(self._colorMovie, title, suffix) if SIGNES is None and COLOUR is True else f"{title}{suffix}"
		starting = (rsx.get('recentBroadcastDate', None) or rsx.get('streamStart', None) or None)
		if starting is None and rsx.get('urlData', '') and rsx['urlData'].get('seo', '') and rsx['urlData']['seo'].get('uploadDate', ''):
			starting = rsx['urlData']['seo']['uploadDate']
		if str(starting)[:4].isdecimal(): # 2025-02-04T18:05:00.000Z
			present = (True if rsx.get('streamStart', None) is not None else False)
			LOCALstart = get_CentralTime(starting, actual=present)
			startdate = LOCALstart.strftime('%d{0}%m{0}%y {1} %H{2}%M').format('.', '•', ':')
			notedate = LOCALstart.strftime('%a{0} %d{0}%m{0}%y {1} %H{2}%M').format('.', '•', ':')
			for av in (('Mon', translation(32108)), ('Tue', translation(32109)), ('Wed', translation(32110)), ('Thu', translation(32111)), \
				('Fri', translation(32112)), ('Sat', translation(32113)), ('Sun', translation(32114))): notedate = notedate.replace(*av)
			aired = LOCALstart.strftime('%d.%m.%Y') # FirstAired
			begins = LOCALstart.strftime('%Y-%m-%dT%H:%M') if KODI_ov20 else LOCALstart.strftime('%d.%m.%Y') # 2023-03-09T12:30:00 = NEWFORMAT // 09.03.2023 = OLDFORMAT
		if notedate: note_3 = translation(32115).format(notedate)
		elif notedate is None and desc != "": note_3 = '[CR]'
		if str(rsx.get('ageRating')) not in ['None', '0', 'nicht definiert']:
			mpaa = str(rsx['ageRating'])
		if rsx.get('productionCountries', '') and isinstance(rsx['productionCountries'], list):
			country = ', '.join(sorted([cou for cou in rsx['productionCountries']]))
		year = rsx['productionYear'] if str(rsx.get('productionYear')).isdecimal() else None
		if rsx.get('actorsV2', '') and isinstance(rsx['actorsV2'], list):
			for index, person in enumerate(rsx['actorsV2'], 1):
				actor = {'name': person.get('name', ''), 'role': person.get('roleName', ''), 'order': index, 'thumb': ''}
				if actor['name'] not in ['' , None]:
					if KODI_ov20:
						CASTING.append(xbmc.Actor(actor['name'], actor['role'], actor['order'], actor['thumb']))
					else: CASTING.append(actor)
		if rsx.get('genres', '') and isinstance(rsx['genres'], list):
			genre = ' / '.join(sorted([gen for gen in rsx['genres']]))
		resources_uno, resources_due = rsx.get('watchImages', {}), rsx.get('images', {})
		if DETAILS is True:
			thumb = (get_Picture('plainLandscape', resources_uno, 'absoluteUri') or get_Picture('artworkLandscape', resources_uno, 'absoluteUri') or get_Picture('default', resources_uno, 'absoluteUri'))
			poster = (get_Picture('plainPortrait', resources_uno, 'absoluteUri') or get_Picture('artworkPortrait', resources_uno, 'absoluteUri'))
		else:
			thumb = (get_Picture('artworkLandscape', resources_uno, 'absoluteUri') or get_Picture('artworkLandscape', resources_due, 'url') or get_Picture('default', resources_uno, 'absoluteUri'))
			poster = (get_Picture('artworkPortrait', resources_uno, 'absoluteUri') or get_Picture('artworkPortrait', resources_due, 'url'))
		return [ident, species, premium, name, seriestitle, desc, duration, season, episode, note_1, note_2, note_3, startdate, begins, aired, year, genre, country, CASTING, mpaa, thumb, poster]

	def playVideo(self, id):
		enableSHIFT = (True if addon_tvnow.getSetting('allow_timeshift') == 'true' else False)
		if ':station:' in id:
			addon_tvnow.setSetting('highest_lives', 'true') if self._showVodsPay and int(addon_tvnow.getSetting('lives_quality')) == 0 else addon_tvnow.setSetting('highest_lives', 'false')
			choosingHD = (True if addon_tvnow.getSetting('highest_lives') == 'true' else False)
		else:
			addon_tvnow.setSetting('highest_videos', 'true') if self._showVodsPay and int(addon_tvnow.getSetting('videos_quality')) == 0 else addon_tvnow.setSetting('highest_videos', 'false')
			choosingHD = (True if addon_tvnow.getSetting('highest_videos') == 'true' else False)
		FINAL_URL, DRM_GUARD = self.api.getPlaybackURL(id, choosingHD)
		if plugin_operate('inputstream.adaptive') and FINAL_URL is not None:
			PVS = xbmcgui.ListItem(path=FINAL_URL, offscreen=True)
			IA_NAME, IA_SYSTEM = 'inputstream.adaptive', 'com.widevine.alpha'
			IA_VERSION = re.sub(r'(~[a-z]+(?:.[0-9]+)?|\+[a-z]+(?:.[0-9]+)?$|[.^]+)', '', xbmcaddon.Addon(IA_NAME).getAddonInfo('version'))[:4]
			DRM_HEADERS = {'x-auth-token': self.api.getToken(), 'User-Agent': USERAGENT, 'Referer': \
				base64.b64decode(b'aHR0cHM6Ly9wbHVzLnJ0bC5kZS8=').decode(), 'Content-Type': 'text/html'}
			PVS.setMimeType('application/dash+xml'), PVS.setContentLookup(False), PVS.setProperty('inputstream', IA_NAME)
			if KODI_un21:
				PVS.setProperty(f'{IA_NAME}.manifest_type', 'mpd') # DEPRECATED ON Kodi v21, because the manifest type is now auto-detected.
			if enableSHIFT and any(snx in id for snx in [':station:', ':live-events:']):
				PVS.setProperty(f'{IA_NAME}.play_timeshift_buffer', 'true') # Allow to start playing a LIVE stream from the beginning of the buffer instead of its end.
			if KODI_ov20:
				PVS.setProperty(f'{IA_NAME}.manifest_headers', f'User-Agent={USERAGENT}') # On KODI v20 and above
			else: PVS.setProperty(f'{IA_NAME}.stream_headers', f'User-Agent={USERAGENT}') # On KODI v19 and below
			if int(IA_VERSION) >= 2150:
				DRM_SPECIES = {'DRM_System': IA_SYSTEM}
				if DRM_GUARD:
					DRM_SPECIES = {'DRM_System': IA_SYSTEM, 'License_Link': DRM_GUARD, 'License_Headers': urlencode(DRM_HEADERS)}
				PVS.setProperty(f'{IA_NAME}.drm_legacy', '|'.join(DRM_SPECIES.values())) # Available from v.21.5.0 / Kodi 21 (Omega) - NEW simple method to configure a single DRM
			else:
				PVS.setProperty(f'{IA_NAME}.license_type', IA_SYSTEM)
				if DRM_GUARD:
					DRM_SPECIES = {'License_Link': DRM_GUARD, 'License_Headers': urlencode(DRM_HEADERS), 'Post_Data': 'R{SSM}|'}
					PVS.setProperty(f'{IA_NAME}.license_key', '|'.join(DRM_SPECIES.values())) # Below v.21.5.0 / Kodi 19+20 - OLD method to configure a single DRM
			#log(f"(navigation.playVideo[1]) IA_VERSION : {IA_VERSION} || FINAL_URL : {FINAL_URL} >>>>> LICENSE : {'|'.join(DRM_SPECIES.values())} <<<<<")
			xbmcplugin.setResolvedUrl(ADDON_HANDLE, True, PVS)
		else:
			return dialog.notification(translation(30521).format('Video'), translation(30524), icon, 10000)

	def create_account(self):
		login = self.api.Login(self.api)
		username = dialog.input('E-Mail-Adresse', type=xbmcgui.INPUT_ALPHANUM)
		password = dialog.input('Passwort', type=xbmcgui.INPUT_ALPHANUM)
		if username is not None and password is not None:
			if len(username) > 0 and len(password) >= 6 and login.sendLogin(username, password):
				addon_tvnow.setSetting('email', username)
				addon_tvnow.setSetting('signature', f'[B]{username}[/B]')
				addon_tvnow.setSetting('acc_token', login.getAccessToken())
				addon_tvnow.setSetting('refresh_token', login.getRefreshToken())
				addon_tvnow.setSetting('profil_token', login.getIdentToken())
				dialog.notification(translation(30561), translation(30562).format(username), icon , 10000)
				if xbmcvfs.exists(RECOM_FILE) and os.stat(RECOM_FILE).st_size > 0:
					xbmcvfs.delete(RECOM_FILE)
				xbmc.executebuiltin('Container.Refresh')
				return True
			dialog.notification(translation(30563), translation(30564), icon , 10000)
		return False

	def erase_account(self):
		addon_tvnow.setSetting('email', "")
		addon_tvnow.setSetting('signature', "")
		addon_tvnow.setSetting('acc_token', "")
		addon_tvnow.setSetting('refresh_token',"")
		addon_tvnow.setSetting('profil_token', "")
		dialog.notification(translation(30565), translation(30566), icon , 10000)
		if xbmcvfs.exists(RECOM_FILE) and os.stat(RECOM_FILE).st_size > 0:
			xbmcvfs.delete(RECOM_FILE)
		xbmc.executebuiltin('Container.Refresh')
