﻿# -*- coding: utf-8 -*-

'''
    Copyright (C) 2025 Pati, realvito

    RTL+ - Webversion

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
'''

from resources.lib.common import *
from resources.lib.navigation import Navigation
import inputstreamhelper
params = dict(parse_qsl(sys.argv[2][1:]))
nav = Navigation()


def run():
	if params:
		if params['action'] == 'listFavorites':
			nav.listFavorites()
		elif params['action'] == 'addFav':
			nav.addFav(params['favor_id'], params.get('favor_title', 'UKNOWN'))
		elif params['action'] == 'removeFav':
			nav.removeFav(params['favor_id'], params.get('favor_title', 'UKNOWN'))
		elif params['action'] == 'listOverviews':
			nav.listOverviews(params['case_id'], params['species'])
		elif params['action'] == 'listSeasons':
			nav.listSeasons(params['id'], params.get('series_title', 'UKNOWN'))
		elif params['action'] == 'listEpisodes':
			nav.listEpisodes(params['season_id'], params.get('season_num', 1), params.get('series_title', 'UKNOWN'))
		elif params['action'] == 'listMovies':
			nav.listMovies(params['id'])
		elif params['action'] == 'listStations':
			nav.listStations(params['case_id'])
		elif params['action'] == 'listEvents':
			nav.listEvents()
		elif params['action'] == 'recommendOverview':
			nav.recommendOverview()
		elif params['action'] == 'topicworldOverview':
			nav.topicworldOverview(params['case_id'])
		elif params['action'] == 'listRecommendTopic':
			nav.listRecommendTopic(params['trace_id'], params['species'], params.get('trace_title', 'UKNOWN'))
		elif params['action'] == 'search':
			nav.searching()
		elif params['action'] == 'playVod':
			nav.playVideo(params['id'])
		elif params['action'] == 'adjustment':
			addon_tvnow.openSettings()
			xbmc.executebuiltin('Container.Refresh')
		elif params['action'] == 'blankFUNC':
			dialog.notification(translation(30531), translation(30532), icon, 10000)
		elif params['action'] == 'forbidden':
			dialog.ok(addon_id, translation(30505))
		elif params['action'] == 'create_account':
			nav.create_account()
		elif params['action'] == 'erase_account':
			nav.erase_account()
	else: ##### Delete old Files in Userdata-Folder to cleanup old Entries #####
		DONE = False ##### [plugin.video.tvnow.de v.1.0.6] - 03.02.2025 #####
		firstSCRIPT = xbmcvfs.translatePath(os.path.join(f"special://home{os.sep}addons{os.sep}{addon_id}{os.sep}lib{os.sep}")).encode('utf-8').decode('utf-8')
		UNO = xbmcvfs.translatePath(os.path.join(firstSCRIPT, 'only_at_FIRSTSTART'))
		if xbmcvfs.exists(UNO):
			SOURCE = xbmcvfs.translatePath(os.path.join(f"special://home{os.sep}userdata{os.sep}addon_data{os.sep}{addon_id}{os.sep}")).encode('utf-8').decode('utf-8')
			if xbmcvfs.exists(SOURCE):
				try:
					xbmc.executeJSONRPC(f'{{"jsonrpc":"2.0","id":1,"method":"Addons.SetAddonEnabled","params":{{"addonid":"{addon_id}","enabled":false}}}}')
					shutil.rmtree(SOURCE, ignore_errors=True)
				except: pass
				xbmcvfs.delete(UNO)
				xbmc.executeJSONRPC(f'{{"jsonrpc":"2.0","id":1,"method":"Addons.SetAddonEnabled","params":{{"addonid":"{addon_id}","enabled":true}}}}')
				xbmc.sleep(500)
				DONE = True
			else:
				xbmcvfs.delete(UNO)
				xbmc.sleep(500)
				DONE = True
		else:
			DONE = True
		if DONE is True:
			if addon_tvnow.getSetting('checkwidevine') == 'true':
				is_helper = inputstreamhelper.Helper('mpd', drm='com.widevine.alpha')
				if is_helper.check_inputstream():
					log("(default.checkwidevine) ### Widevine ist auf diesem Gerät installiert und aktuell !!! ###")
				else:
					failing("(default.checkwidevine) ERROR - ERROR - ERROR :\nXXXXX !!! Widevine oder Inputstream.Adaptive wurde auf diesem Gerät NICHT gefunden !!! XXXXX")
					dialog.notification(translation(30521).format('Widevine'), translation(30533), icon, 12000)
			if not xbmcvfs.exists(os.path.join(data_path, 'settings.xml')):
				xbmcvfs.mkdirs(data_path)
				xbmc.executebuiltin(f"Addon.OpenSettings({addon_id})")
			nav.mainMenu()

run()
